"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var Arc2d_exports = {};
__export(Arc2d_exports, {
  Arc2d: () => Arc2d
});
module.exports = __toCommonJS(Arc2d_exports);
var import_Vec = require("../Vec");
var import_intersect = require("../intersect");
var import_utils = require("../utils");
var import_Geometry2d = require("./Geometry2d");
var import_geometry_constants = require("./geometry-constants");
class Arc2d extends import_Geometry2d.Geometry2d {
  _center;
  radius;
  start;
  end;
  largeArcFlag;
  sweepFlag;
  measure;
  angleStart;
  angleEnd;
  constructor(config) {
    super({ ...config, isFilled: false, isClosed: false });
    const { center, sweepFlag, largeArcFlag, start, end } = config;
    if (start.equals(end)) throw Error(`Arc must have different start and end points.`);
    this.angleStart = import_Vec.Vec.Angle(center, start);
    this.angleEnd = import_Vec.Vec.Angle(center, end);
    this.radius = import_Vec.Vec.Dist(center, start);
    this.measure = (0, import_utils.getArcMeasure)(this.angleStart, this.angleEnd, sweepFlag, largeArcFlag);
    this.start = start;
    this.end = end;
    this.sweepFlag = sweepFlag;
    this.largeArcFlag = largeArcFlag;
    this._center = center;
  }
  nearestPoint(point) {
    const { _center, measure, radius, angleEnd, angleStart, start: A, end: B } = this;
    const t = (0, import_utils.getPointInArcT)(measure, angleStart, angleEnd, _center.angle(point));
    if (t <= 0) return A;
    if (t >= 1) return B;
    const P = _center.clone().add(point.clone().sub(_center).uni().mul(radius));
    let nearest;
    let dist = Infinity;
    let d;
    for (const p of [A, B, P]) {
      d = import_Vec.Vec.Dist2(point, p);
      if (d < dist) {
        nearest = p;
        dist = d;
      }
    }
    if (!nearest) throw Error("nearest point not found");
    return nearest;
  }
  hitTestLineSegment(A, B) {
    const { _center, radius, measure, angleStart, angleEnd } = this;
    const intersection = (0, import_intersect.intersectLineSegmentCircle)(A, B, _center, radius);
    if (intersection === null) return false;
    return intersection.some((p) => {
      const result = (0, import_utils.getPointInArcT)(measure, angleStart, angleEnd, _center.angle(p));
      return result >= 0 && result <= 1;
    });
  }
  getVertices() {
    const { _center, measure, length, radius, angleStart } = this;
    const vertices = [];
    for (let i = 0, n = (0, import_geometry_constants.getVerticesCountForLength)(Math.abs(length)); i < n + 1; i++) {
      const t = i / n * measure;
      const angle = angleStart + t;
      vertices.push((0, import_utils.getPointOnCircle)(_center, radius, angle));
    }
    return vertices;
  }
  getSvgPathData(first = true) {
    const { start, end, radius, largeArcFlag, sweepFlag } = this;
    return `${first ? `M${start.toFixed()}` : ``} A${radius} ${radius} 0 ${largeArcFlag} ${sweepFlag} ${end.toFixed()}`;
  }
  getLength() {
    return this.measure * this.radius;
  }
}
//# sourceMappingURL=Arc2d.js.map
